//----------------------------------------------------------------------------
//
// Copyright (C) Sartorius Stedim Data Analytics AB 2017 -
//
// Use, modification and distribution are subject to the Boost Software
// License, Version 1.0. (See http://www.boost.org/LICENSE_1_0.txt)
//
//----------------------------------------------------------------------------

#ifdef _WIN32
#include "stdafx.h"
#include <io.h>
#include <tchar.h>
#endif
#include <stdio.h>
#include <stdlib.h>
#ifdef __unix__
#include <unistd.h>
#endif

#include "sqprunner.h"
#include "utf8util.h"

#ifdef _WIN32
int _tmain(int argc, TCHAR** argv)
{
   FILE* pOutFile;
   SQPRunner oSQPRunner;
   char* u8argv1;
   char* u8argv2;

   if (argc < 3)
   {
      _ftprintf(stderr, _T("\n%s Usage:\n\n")
         _T(".\\SQPWithFileReader.exe <USP file> <Predictionset file> [output file] [Plug-in path]\n\n")
         _T("    USP file            ---  is a SIMCA project file\n")
         _T("    Predictionset file  ---  is a file containing a predictionset for the given .usp file.\n")
         _T("    output file         ---  is a file to write output. If omitted stdout is used\n")
         _T("    Plug-in path        ---  is the path to the file reader plug-in if such exist.\n\n"), argv[0]);
      return -1;
   }
   if (_taccess(argv[1], 04) != 0)
   {
      _ftprintf(stderr, _T("\n%s: Could not open: %s\n")
         _T("Make sure that the file is not missing, is a SIMCA- project ")
         _T("and is readable for your user\n\n"), argv[0], argv[1]);
      return -1;
   }
   if (_taccess(argv[2], 04) != 0)
   {
      _ftprintf(stderr, _T("\n%s: Could not open: %s\n")
         _T("Make sure that the file is not missing ")
         _T("and is readable for your user\n\n"), argv[0], argv[2]);
      return -1;
   }

   u8argv1 = TCHARtoUTF8(argv[1]);
   u8argv2 = TCHARtoUTF8(argv[2]);

   if (argc > 3)
   {
      char* u8argv4;

      pOutFile = _tfopen(argv[3], _T("w"));



      if (argc == 5)
      {
         u8argv4 = TCHARtoUTF8(argv[4]);
         SQPRunner_Init(&oSQPRunner, u8argv1, u8argv2, u8argv4);
         free(u8argv4);
      }
      else
      {
         SQPRunner_Init(&oSQPRunner, u8argv1, u8argv2, NULL);
      }

      free(u8argv2);
   }
   else
   {
      pOutFile = stdout;
      SQPRunner_Init(&oSQPRunner, u8argv1, u8argv2, NULL);
   }

   SQPRunner_Run(&oSQPRunner, pOutFile, stderr);
   fclose(pOutFile);
   SQPRunner_Destroy(&oSQPRunner);

   return 0;
}
#else
int main(int argc, char** argv)
{
   FILE* pOutFile;
   SQPRunner oSQPRunner;

   if (argc == 1)
   {
      fprintf(stderr, "%s: Usage:\nSQPWithFileReader USP file Predictionset file [output file] [Plug-in path]\n"
         "USP file is a SIMCA project file\n"
         "Predictionset file is a file containing a predictionset for the given .usp file.\n"
         "output file is a file to write output. "
         "If omitted stdout is used\n"
         "Plug-in path is the path to the file reader plug-in if such exist.\n", argv[0]);
      return -1;
   }
   if (access(argv[1], 04) != 0)
   {
      fprintf(stderr, "%s: Could not open: %s\n"
         "Make sure that the file is not missing, is a SIMCA project "
         "and is readable for your user\n", argv[0], argv[1]);
      return -1;
   }
   if (access(argv[2], 04) != 0)
   {
      fprintf(stderr, "%s: Could not open: %s\n"
         "Make sure that the file is not missing "
         "and is readable for your user\n", argv[0], argv[2]);
      return -1;
   }

   if (argc > 3)
   {
      pOutFile = fopen(argv[3], "w");
      if (argc == 5)
      {
         SQPRunner_Init(&oSQPRunner, argv[1], argv[2], argv[4]);
      }
      else
      {
         SQPRunner_Init(&oSQPRunner, argv[1], argv[2], NULL);
      }
   }
   else
   {
      pOutFile = stdout;
      SQPRunner_Init(&oSQPRunner, argv[1], NULL, NULL);
   }
   SQPRunner_Run(&oSQPRunner, pOutFile, stderr);
   fclose(pOutFile);
   SQPRunner_Destroy(&oSQPRunner);

   return 0;
}
#endif
